﻿# -*- coding: utf-8 -*-

import bpy
from bpy.props import BoolProperty, IntProperty, FloatVectorProperty

if("View3dDeco" in locals()):
	import importlib
	importlib.reload(View3dDeco)

from . import View3dDeco

#### =======================================================================
inst = None

#### =======================================================================
class AsView3dBorderDecoPrefs(bpy.types.AddonPreferences):
	'''アドオン設定'''
	bl_idname = "AsView3dBorderDeco"

	#### ----------------
	def Update_Width(self, context):
		self.Update_Flags(bw= self.borderWidth)

	def Update_Offset(self, context):
		self.Update_Flags(bo= self.borderOffset)

	def Update_Label(self, context):
		self.Update_Flags(sl= self.showLabel)

	def Update_IgnoreCam(self, context):
		self.Update_Flags(ic= self.ignoreCamera)

	#### ----------------
	def Update_Flags(self, **kwd):
		global inst
		if(inst):
			inst.Update_Flags(**kwd)

	#### ----------------
	def Update_Stat(self, tag, stat, colr):
		global inst
		if(inst):
			inst.Update_Stat(tag, stat, colr)

	#### ----------------
	class DESC(object):
		OBJ  = "オブジェクト"
		MESH = "メッシュ編集"
		CRV  = "カーブ編集"
		SURF = "サーフェス編集"
		BONE = "アーマチュア編集"
		TEXT = "テキスト編集"
		BALL = "メタボール編集"
		LATT = "ラティス編集"
		GPEN = "グリースペンシル編集"
		POSE = "ポーズ"
		SCLP = "スカルプト"
		PWGT = "ウェイト"
		PVTX = "頂点カラー"
		PTEX = "テクスチャ"
		PGP  = "Gペンシル:ドロー"
		WGP  = "Gペンシル:ウェイト"
		SGP  = "Gペンシル:スカルプト"
		PRTL = "パーティクル"
		__slots__=()

	fvKwd = dict(name="", subtype="COLOR", size=4, min=0, max=1.0)

	tags = (
		"OBJECT", "EDIT_MESH", "EDIT_CURVE", "EDIT_SURFACE", "EDIT_ARMATURE", "EDIT_TEXT",
		"EDIT_METABALL", "EDIT_LATTICE", "EDIT_GPENCIL", "POSE", "SCULPT", "PAINT_WEIGHT",
		"PAINT_VERTEX", "PAINT_TEXTURE", "PAINT_GPENCIL", "WEIGHT_GPENCIL", "SCULPT_GPENCIL", "PARTICLE"
		)

	descs = (
		DESC.OBJ,  DESC.MESH, DESC.CRV,  DESC.SURF, DESC.BONE, DESC.TEXT,
		DESC.BALL, DESC.LATT, DESC.GPEN, DESC.POSE, DESC.SCLP, DESC.PWGT,
		DESC.PVTX, DESC.PTEX, DESC.PGP,  DESC.WGP,  DESC.SGP,  DESC.PRTL,
		)

	keysStat = (
		"useOBJ",  "useMESH", "useCRV",  "useSURF", "useBONE", "useTEXT",
		"useBALL", "useLATT", "useGPEN", "usePOSE", "useSCLP", "usePWGT",
		"usePVTX", "usePTEX", "usePGP",  "useWGP",  "useSGP",  "usePRTL",
		)

	keysColr = (
		"colrOBJ",  "colrMESH", "colrCRV",  "colrSURF", "colrBONE", "colrTEXT",
		"colrBALL", "colrLATT", "colrGPEN", "colrPOSE", "colrSCLP", "colrPWGT",
		"colrPVTX", "colrPTEX", "colrPGP",  "colrWGP",  "colrSGP",  "colrPRTL",
		)

	updateFuncs = (
		"Update_Obj",  "Update_Mesh", "Update_Crv",  "Update_Surf", "Update_Bone", "Update_Text",
		"Update_Ball", "Update_Latt", "Update_GPen", "Update_Pose", "Update_Sclp", "Update_PWgt",
		"Update_PVtx", "Update_PTex", "Update_PGP",  "Update_WGP",  "Update_SGP",  "Update_Prtl",
		)

	#### ----------------
	showLabel:    BoolProperty(name= "モードを表示", description= "ビューの上部にモード名を表示", default= True, update= Update_Label)
	ignoreCamera: BoolProperty(name= "カメラで無効", description= "カメラからのビューの場合に枠線表示をしない", default= True, update= Update_IgnoreCam)
	borderWidth:  IntProperty(name= "枠線幅", description= "枠線の太さ[ 1～100 ]", min= 1, max= 100, default= 4, update= Update_Width)
	borderOffset: IntProperty(name= "枠オフセット", description= "枠線のオフセット[ 0～100 ]", min= 0, max= 100, default= 0, update= Update_Offset)

	#### ----------------
	initialStatsDct = View3dDeco.View3dBorderDeco.initialStatsDct	# key:(stat, ((rgba),*8))
	for (tag, kStat, kCol, desc, func) in zip(tags, keysStat, keysColr, descs, updateFuncs):
		# ここでupdate関数の定義
		exec("{FN}=lambda self,context: self.Update_Stat(\"{TAG}\", self.{ST}, tuple(self.{COL}))".format(FN=func, TAG=tag, ST=kStat, COL=kCol))
		__annotations__[kCol] = FloatVectorProperty(description= desc, default= initialStatsDct[tag][1][0], update= eval(func), **fvKwd)

	for (kStat, desc, func) in zip(keysStat, descs, updateFuncs):
		__annotations__[kStat] = BoolProperty(name= desc, description= desc, default= True, update= eval(func))

	#### ----------------
	def paya(self, base, kStat, kColr):
		row = base.split(factor=.7)
		row.prop(self, kStat)
		clm = row.column()
		clm.prop(self, kColr)
		clm.enabled = getattr(self, kStat)	# 色部の反応がイマイチ

	#### ----------------
	def draw(self, context):
		baseBox = self.layout#.box()
		baseBox.scale_y = .9

		subBox = baseBox.box()
		flw = subBox.column_flow(columns = 4)
		c0 = flw.column()
		c0.prop(self, "showLabel")
		c1 = flw.column()
		c1.prop(self, "ignoreCamera")
		c2 = flw.column()
		c2.use_property_split = True
		c2.prop(self, "borderWidth")
		c3 = flw.column()
		c3.use_property_split = True
		c3.prop(self, "borderOffset")

		subBox = baseBox.box()
		flw = subBox.column_flow(columns = 2)

		c3 = flw.box().column()
		for (kStat, kColr) in zip(self.keysStat[:9], self.keysColr[:9]):
			self.paya(c3, kStat, kColr)

		c4 = flw.box().column()
		for (kStat, kColr) in zip(self.keysStat[9:], self.keysColr[9:]):
			self.paya(c4, kStat, kColr)

#### =======================================================================
def register():
	global inst
	inst = View3dDeco.View3dBorderDeco()
	bpy.utils.register_class(AsView3dBorderDecoPrefs)

	pref = bpy.context.preferences.addons["AsView3dBorderDeco"].preferences
	inst.Update_Flags(bw= pref.borderWidth, bo= pref.borderOffset, sl= pref.showLabel, ic= pref.ignoreCamera)
	for (tag, kStat, kColr) in zip(AsView3dBorderDecoPrefs.tags, AsView3dBorderDecoPrefs.keysStat, AsView3dBorderDecoPrefs.keysColr):
		inst.Update_Stat(tag, getattr(pref, kStat), tuple(getattr(pref, kColr)))

#### -----------------------------------------------------------------------
def unregister():
	bpy.utils.unregister_class(AsView3dBorderDecoPrefs)
	global inst
	if(inst):
		inst.unregist()
		inst = None
